"use client"
import { cn } from "@/lib/utils";
import { TransformedAgency } from "@/types/transformers";
import { ComponentWithClassNameAndChildren } from "@/types/utils";
import { Cell } from "@tanstack/react-table";
import { CircleEllipsis, TriangleAlert } from "lucide-react";

export function AgenciesCellValidationErrors({ cell }: { cell: Cell<TransformedAgency, unknown> }) {
  const { status } = cell.getValue<TransformedAgency>()

  return (
    <INTERNAL__Wrapper>
      {getStatusFromPreviewAndLiveStatus(status.option)}
    </INTERNAL__Wrapper>
  )
}

export function getStatusFromPreviewAndLiveStatus(option: TransformedAgency["status"]["option"] | undefined) {
  if (option === "FAILED") {
    return <TriangleAlert className="size-4 text-destructive" />
  }

  return <CircleEllipsis className="size-4 text-muted-foreground" />
}

function INTERNAL__Wrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={cn("flex flex-row gap-2 items-center", className)}>
      {children}
    </div>
  )
}
